﻿<%@ Page Title="Lab Results Details" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="LabResults.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.LabResults" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
    <div class = "excludeSaveWarnings">
    <br />
   <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <br />
        <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
    </div>
    <br />
    <asp:GridView ID="GridViewLabResults" runat="server" AllowPaging="True" OnRowCommand="SelectActivity" AutoGenerateColumns="False"  
        DataKeyNames="ActivityId" PageSize = "20" AllowSorting="True" CssClass="gridRegistry" PagerStyle-CssClass="pager" 
        EmptyDataRowStyle-CssClass="gridRegistryEmpty" DataSourceID="ObjectDataSourceGridViewLabResults">
        <Columns>
             <asp:TemplateField 
                HeaderText="Workflow ID" 
                SortExpression="CaseId">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelCaseId" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("CaseId"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

           <asp:TemplateField HeaderText="Lab Report Date" SortExpression="LabReportDate" Visible="false" >
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelLabReportDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LabReportDate", "{0:d}"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Entry Date" SortExpression="ReceivedDate">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelReceivedDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReceivedDate", "{0:d}"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Accepted Date" SortExpression="AcceptedDate">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelAcceptedDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("AcceptedDate", "{0:MM/dd/yyyy}"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Patient Name" 
                SortExpression="PatientName">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientName"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            
            
             <asp:TemplateField 
                HeaderText="Site Number" 
                SortExpression="Site">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelSite" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Site"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField 
                HeaderText="Facility" 
                SortExpression="SiteName">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelSiteName" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("SiteName"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
              
                
            <asp:TemplateField 
                HeaderText="Specimen Type" 
                SortExpression="CaseType">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelCaseType" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("CaseType"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:ButtonField 
                ButtonType = "Button" 
                Text = "Select" 
                CommandName = "Details"  />
        </Columns>
    </asp:GridView>
    <asp:ObjectDataSource ID="ObjectDataSourceGridViewLabResults" runat="server" 
        SelectMethod="GetNewLabResults" 
        SelectCountMethod="GetNewLabResultsCount"
        OnSelecting="Ds_Selecting"
        onselected="ObjectDataSourceGridViewLabResults_Selected" 
        TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager"
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SortParameterName="sort"
        EnablePaging="True" >
    <SelectParameters>
        <asp:QueryStringParameter Name = "id" QueryStringField = "OrderType" DefaultValue="0" /> 
        <asp:ControlParameter Name = "searchValue" ControlID = "TextBoxSearchCriteria" DefaultValue = "" />
    
    </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>